/*
 *  linux/arch/arm/mach-uniphier/sleep.S
 *
 *  Copyright (C) 2012 Panasonic Corporation
 *  - Derived from arch/arm/mach-omap2/sleep44xx.S
 *
 * This program is free software,you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#include <linux/linkage.h>
#include <asm/system.h>
#include <asm/smp_scu.h>
#include <asm/memory.h>

#include <mach/l2ca-regs.h>

#include <mach/backup-ram-layout.h>

#if defined(CONFIG_PM)

/*
 * =============================
 * == CPU suspend finisher ==
 * =============================
 *
 * int uniphier_finish_suspend(unsigned long cpu_state)
 *
 * This function code saves the CPU context and performs the CPU
 * power down sequence. Calling WFI effectively changes the CPU
 * power domains states to the desired target power state.
 *
 * @cpu_state : contains context save state (r0)
 *	0 - No context lost
 * 	1 - CPUx L1 and logic lost + GIC + L2 lost
 * 	2 - CPUx L1 and logic lost + GIC + L2 lost + power down
 * @return: This function never returns for CPU OFF and DORMANT power states.
 * Post WFI, CPU transitions to DORMANT or OFF power state and on wake-up
 * from this follows a full CPU reset path via ROM code to CPU restore code.
 * The restore function pointer is stored at CPUx_WAKEUP_NS_PA_ADDR_OFFSET.
 * It returns to the caller for CPU INACTIVE and ON power states or in case
 * CPU failed to transition to targeted OFF/DORMANT state.
 */
ENTRY(uniphier_finish_suspend)
	stmfd	sp!, {lr}
	cmp	r0, #0x0
	beq	do_WFI				@ No lowpower state, jump to WFI
	stmfd	sp!, {r0}

	/*
	 * Flush all data from the L1 data cache before disabling
	 * SCTLR.C bit.
	 */
#if 0
	/* clean seucre L1 here */
#endif
skip_secure_l1_clean:
	bl	v7_flush_dcache_all_saveregs

	/*
	 * Clear the SCTLR.C bit to prevent further data cache
	 * allocation. Clearing SCTLR.C would make all the data accesses
	 * strongly ordered and would not hit the cache.
	 */
	mrc	p15, 0, r0, c1, c0, 0
	bic	r0, r0, #(1 << 2)		@ Disable the C bit
	mcr	p15, 0, r0, c1, c0, 0
	isb

	/*
	 * Invalidate L1 data cache. Even though only invalidate is
	 * necessary exported flush API is used here. Doing clean
	 * on already clean cache would be almost NOP.
	 */
	bl	v7_flush_dcache_all_saveregs

#if defined(CONFIG_SMP)
	/*
	 * Switch the CPU from Symmetric Multiprocessing (SMP) mode
	 * to AsymmetricMultiprocessing (AMP) mode by programming
	 * the SCU power status to DORMANT or OFF mode.
	 * This enables the CPU to be taken out of coherency by
	 * preventing the CPU from receiving cache, TLB, or BTB
	 * maintenance operations broadcast by other CPUs in the cluster.
	 */
	bl	uniphier_get_backup_ram_base
	mov	r8, r0
#if 0
	/* change secure SCU here */ 
#endif
scu_gp_set:
	mrc	p15, 0, r0, c0, c0, 5		@ Read MPIDR
	ands	r0, r0, #0x0f
	ldreq	r1, [r8, #SCU_OFFSET0]
	ldrne	r1, [r8, #SCU_OFFSET1]
	bl	scu_base_addr
	bl	scu_power_mode
skip_scu_gp_set:
	mrc	p15, 0, r0, c1, c1, 2		@ Read NSACR data
	tst	r0, #(1 << 18)
	mrcne	p15, 0, r0, c1, c0, 1
	bicne	r0, r0, #(1 << 6)		@ Disable SMP bit
	mcrne	p15, 0, r0, c1, c0, 1
#endif	/* CONFIG_SMP */
	isb
	dsb

#ifdef CONFIG_UNIPHIER_HAS_L2CA
	dsb
#ifdef CONFIG_UNIPHIER_L2CACHE_ENABLE
#define SSC_VADDR(paddr)	(paddr-UNIPHIER_SSC_START2+UNIPHIER_SSC_BASE2)
	ldr	r0, =SSC_VADDR(SSC_OFFSET_BASE + L2COQM_OFFSET)
	ldr	r1, =L2COQM_CE | L2COQM_CW_FLAG | L2COQM_CM_WBINV | L2COQM_S_ALL
	ldr	r2, =SSC_VADDR(SSC_OFFSET_BASE + L2COPPQSEF_OFFSET)
	str	r1, [r0]
1:	ldr	r3, [r2]
	ands	r3, r3, #L2COPPQSEF_FE | L2COPPQSEF_OE
	bne	1b
	
	ldr	r0, =SSC_VADDR(SSC_OFFSET_BASE + L2COLPQS_OFFSET)
	ldr	r1, = L2COLPQS_EF
1:	ldr	r2, [r0]
	cmp	r2, r1						@ Check EF=1 & QST=0
	bne	1b
	str	r2, [r0]
#endif /* CONFIG_UNIPHIER_L2CACHE_ENABLE */
l2c_sync:
	ldr	r0, =SSC_VADDR(SSC_OFFSET_BASE + L2COPE_OFFSET)
	ldr	r1, =L2COPE_CM_FLSH_PFBUF
	ldr	r2, =L2COPE_CM_SYNC
	str	r1, [r0]
	ldr	r1, [r0]
	str	r2, [r0]
	ldr	r2, [r0]

l2c_dummy_read:
	ldr	r0, =ucwg_dummy_p
	ldr	r0, [r0]
	mov	r1, #0
	str	r1, [r0]
	ldr	r1, [r0]
	ldr	r0, =UNIPHIER_KERNEL_UNCACHE_BASE
	ldr	r0, [r0]
	dsb
#endif /* CONFIG_UNIPHIER_HAS_L2CA */

	ldmfd	sp!, {r0}
do_WFI:
	cmp	r0, #0x2
	bleq	uniphier_get_lpmctl_base
	bleq	uniphier_prepare_wfi
	bl	uniphier_do_wfi

	/*
	 * CPU is here when it failed to enter OFF/DORMANT or
	 * no low power state was attempted.
	 */
	mrc	p15, 0, r0, c1, c0, 0
	tst	r0, #(1 << 2)			@ Check C bit enabled?
	orreq	r0, r0, #(1 << 2)		@ Enable the C bit
	mcreq	p15, 0, r0, c1, c0, 0
	isb

#if defined(CONFIG_SMP)
	/*
	 * Ensure the CPU power state is set to NORMAL in
	 * SCU power state so that CPU is back in coherency.
	 * In non-coherent mode CPU can lock-up and lead to
	 * system deadlock.
	 */
	mrc	p15, 0, r0, c1, c0, 1
	tst	r0, #(1 << 6)			@ Check SMP bit enabled?
	orreq	r0, r0, #(1 << 6)
	mcreq	p15, 0, r0, c1, c0, 1
	isb
#if 0
	/* change secure SCU here */
#endif
scu_gp_clear:
	bl	scu_base_addr
	mov	r1, #SCU_PM_NORMAL
	bl	scu_power_mode
#endif	/* CONFIG_SMP */
skip_scu_gp_clear:
	isb
	dsb
	mov	r0, #0
	ldmfd	sp!, {pc}
ENDPROC(uniphier_finish_suspend)

/*
 * ============================
 * == CPU resume entry point ==
 * ============================
 *
 * void uniphier_cpu_resume(void)
 *
 * ROM code jumps to this function while waking up from CPU
 * OFF or DORMANT state. Physical address of the function is
 * stored in backup RAM while entering to OFF or DORMANT mode.
 * The restore function pointer is stored at CPUx_WAKEUP_NS_PA_ADDR_OFFSET.
 */
ENTRY(uniphier_cpu_resume)
#if 0
	/*
	 * Configure ACTRL and enable NS SMP bit access.
	 */
#endif
enable_smp_bit:
#if defined(CONFIG_SMP)
	mrc	p15, 0, r0, c1, c0, 1
	tst	r0, #(1 << 6)			@ Check SMP bit enabled?
	orreq	r0, r0, #(1 << 6)
	mcreq	p15, 0, r0, c1, c0, 1
#endif	/* CONFIG_SMP */
	isb
skip_ns_smp_enable:

	b	cpu_resume			@ Jump to generic resume
ENDPROC(uniphier_cpu_resume)
#endif

__preload_start:
ENTRY(uniphier_prepare_wfi)
	stmfd	sp!, {lr}
	isb
	dsb
	dmb
	ldr	r1, =__preload_start
	ldr	r2, =__preload_end
1:
	ldr	r3, [r1], #0x04
	cmp	r1, r2
	bne	1b

	mov	r1, #0x2
	ldr	r2, [r0]
	isb
	dsb
	dmb

1:
	str	r1, [r0]
	ldr	r2, [r0]
	cmp	r1, r2
	bne	1b
	ldmfd	sp!, {pc}
ENDPROC(uniphier_prepare_wfi)

ENTRY(uniphier_do_wfi)
	stmfd	sp!, {lr}

	/*
	 * Execute an ISB instruction to ensure that all of the
	 * CP15 register changes have been committed.
	 */
	isb

	/*
	 * Execute a barrier instruction to ensure that all cache,
	 * TLB and branch predictor maintenance operations issued
	 * by any CPU in the cluster have completed.
	 */
	dsb
	dmb

	/*
	 * Execute a WFI instruction and wait until the
	 * STANDBYWFI output is asserted to indicate that the
	 * CPU is in idle and low power state. CPU can specualatively
	 * prefetch the instructions so add NOPs after WFI. Sixteen
	 * NOPs as per Cortex-A9 pipeline.
	 */
	wfi					@ Wait For Interrupt
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop

	ldmfd	sp!, {pc}
ENDPROC(uniphier_do_wfi)
__preload_end:
